<?php

namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;
use Log;
use Auth;
use Pusher\Pusher;

class MessageSent implements ShouldBroadcastNow
{
    use Dispatchable, InteractsWithSockets, SerializesModels;
    public $message, $conversationId;

    /**
     * Create a new event instance.
     */
    public function __construct($message, $conversationId, $recipientIdArray)
    {
        $this->message = $message->load('sender');
        $this->conversationId = $conversationId;

        $onlineUserIds = $this->handleOnlineCheck($conversationId);
        foreach($onlineUserIds as $user){
            $message->messageReads->where('user_id', $user->id)->first()?->update(['read_at' => now()->addHours(5)]);
        }
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return array<int, \Illuminate\Broadcasting\Channel>
     */
    public function broadcastOn()
    {   
        return [
            new PresenceChannel('chat.' . $this->conversationId)
            // new PrivateChannel('chat.'. $this->message->sender_id),
            // new PrivateChannel('chat.'. $this->receiverId),
        ];
    }

    public function handleOnlineCheck($conversationId)
    {
        $pusher = new Pusher(
            config('broadcasting.connections.pusher.key'),
            config('broadcasting.connections.pusher.secret'),
            config('broadcasting.connections.pusher.app_id'),
            [
                'cluster' => config('broadcasting.connections.pusher.options.cluster'),
                'useTLS' => true,
            ]
        );

        $channelName = 'presence-chat.' . $conversationId;

        try {
            $users = $pusher->get('/channels/' . $channelName . '/users');
            $userList = collect($users->users)->toArray();
            
            return $userList;
        } catch (\Exception $e) {
            Log::error("Error fetching Pusher users: " . $e->getMessage());
            
            return false;
        }
    }



    
}
