<?php

namespace App;

use App\Models\Document;

trait HasDocument
{
    public function storeDocuments($documentInfoArray){
        if ($documentInfoArray['relationType'] == 'single') {
            $file = $documentInfoArray['file'];
            $user = $documentInfoArray['user'];

            $path = $file->store('profile-images', 'public');
            $document = Document::create([
                'file_name' => $file->getClientOriginalName(),
                'file_path' => $path,
                'mime_type' => $file->getClientMimeType(),
                'type' => $documentInfoArray['type']
            ]);

            $user->documents()->attach($document->id);   
        }
    }
}
