<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Lead;
use App\Models\LeadComment;
use App\Models\LeadExtra;
use Auth;
use DB;
use App\Http\Requests\LeadRequest;

class LeadController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $leads = Lead::paginate(25);
        return view('leads.list', [
            'leads' => $leads
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('leads.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(LeadRequest $request)
    {
        $leadParams = $request->lead;
        $leadParams['created_by_id'] = Auth::user()->id;
        DB::beginTransaction();
        $lead = Lead::firstOrCreate($leadParams);
        if ($lead) {
            LeadComment::firstOrCreate([
                'lead_id' => $lead->id,
                'comment' => $request->comment
            ]);
            
            foreach ($request->groupa as $value) {
                LeadExtra::firstOrCreate([
                    'lead_id' => $lead->id,
                    'value' => $value['extras_text'],
                    'type' => $value['extras_type']
                ]);
            }

            DB::commit();
            return redirect()->route('leads.index')->with('success', 'Lead created successfully');
        }
        else{
            DB::rollback();
            return redirect()->back()->with('error', 'Lead could not be created!');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $lead = Lead::find($id);

        return view('leads.edit', ['lead' => $lead]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        if ($request->type == 'updateLead') {
            $leadParams = $request->lead;
            $lead = Lead::find($id);
            if ($lead) {
                DB::beginTransaction();
                $lead->update($leadParams);
                if (!$lead->extras->isEmpty()) {
                    $lead->extras->each->delete();
                }
                if (isset($request->groupb)) {
                    foreach (array_filter($request->groupb) as $value) {
                        if ($value['extras_text'] && $value['extras_type']) {
                            LeadExtra::firstOrCreate([
                                'lead_id' => $lead->id,
                                'value' => $value['extras_text'],
                                'type' => $value['extras_type']
                            ]);   
                        }
                    }
                }

                if (isset($request->groupa)) {
                    foreach (array_filter($request->groupa) as $value) {
                        if ($value['extras_text'] && $value['extras_type']) {
                            LeadExtra::firstOrCreate([
                                'lead_id' => $lead->id,
                                'value' => $value['extras_text'],
                                'type' => $value['extras_type']
                            ]);   
                        }
                    }
                }

                DB::commit();
                return redirect()->back()->with('success', 'Lead updated successfully!');
            }
            return redirect()->back()->with('error', 'Lead not found!');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $lead = Lead::find($id);
        if ($lead) {
            DB::beginTransaction();
            if ($lead->comments?->each->delete() && $lead->extras?->each->delete()) {
                $lead->delete();
                DB::commit();
                return redirect()->back()->with('success', 'Lead deleted successfully!');
            }
        }
        return redirect()->back()->with('error', 'Lead not found!');
    }
}
