<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use App\HasDocument;
use App\Models\User;
use Hash;
use DB;

class ProfileController extends Controller
{
    use HasDocument;
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $user = Auth::user();
        if ($user->type == 'admin') {
            $profileImageObj =  $user->documents->where('type', 'profileImage')->first();
            
            return view('profile.admin', ['user' => $user, 'profileImageObj' => $profileImageObj]);
        }
        elseif ($user->type == 'staff_member') {
            $profileImageObj =  $user->documents->where('type', 'profileImage')->first();
            $cnicObj = $user->documents->where('type', 'cnic')->first();
            
            return view('profile.staff-member', ['user' => $user, 'profileImageObj' => $profileImageObj, 'cnicObj' => $cnicObj]);
        }
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $user = User::find($id);
        if ($request->type == 'adminProfileUpdate') {
            $emailUniqueCheck = User::where('email', $request->email)->where('id', '!=', $user->id)->exists();
            if ($emailUniqueCheck) {
                return redirect()->back()->with('error', 'A user already exists with this email');
            }

            if ($request->hasFile('profileImg')) {
                $documentInfoArray = [
                    'file' => $request->file('profileImg'),
                    'user' => $user,
                    'type' => 'profileImage',
                    'relationType' => 'single'
                ];

                $this->storeDocuments($documentInfoArray);
            }
            $user->update([
                        'name' => $request->name,
                        'email' => $request->email,
                    ]);

            return redirect()->back()->with('success','Profile updated successfully');
        }
        elseif ($request->type == 'updatePassword') {
            $request->validate([
                'password_confirmation' => ['required', 'same:password'],
            ]);
            if(Hash::check($request->current_password, $user->password)){
                $user->update([
                    'password' => Hash::make($request->password)
                ]);
                return redirect()->back()->with('success','Password updated successfully');
            }
            else{
                return redirect()->back()->with('error','Current password is incorrect');
            }
        }
        elseif ($request->type == 'staffMemberProfileUpdate') {
            DB::beginTransaction();
            if ($user->update($request->user) && $user->member->update($request->member)
                && $user->member->update(['is_updated' => true])) {
                if ($request->hasFile('profileImg')) {
                    $documentInfoArray = [
                        'file' => $request->file('profileImg'),
                        'user' => $user,
                        'type' => 'profileImage',
                        'relationType' => 'single'
                    ];

                    $this->storeDocuments($documentInfoArray);
                }
                if ($request->hasFile('cnic')) {
                    $documentInfoArray = [
                        'file' => $request->file('cnic'),
                        'user' => $user,
                        'type' => 'cnic',
                        'relationType' => 'single'
                    ];

                    $this->storeDocuments($documentInfoArray);
                }
                DB::commit();
                return redirect()->back()->with('success', 'Profile updated successfully!');
            }
            else{
                DB::rollback();
                return redirect()->back()->with('error', 'Profile could not be updated!');
            }
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
