<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\StaffMember;
use App\Http\Requests\StaffMemberRequest;
use Auth;
use DB;
use App\HasDocument;

class StaffMemberController extends Controller
{
    use HasDocument;
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $users = User::where('type', 'staff_member')->get();
        return view('staff-members.list', [
            'users' => $users
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('staff-members.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StaffMemberRequest $request)
    {
        $userParams = $request->user;
        $userParams['password'] = '123456789';
        DB::beginTransaction();
        $user = User::firstOrCreate($userParams);
        if ($user) {
            $memberParams = $request->member;
            $memberParams['user_id'] = $user->id;
            $member = StaffMember::firstOrCreate($memberParams);
            if ($member) {
                if ($request->hasFile('profileImg')) {
                    $documentInfoArray = [
                        'file' => $request->file('profileImg'),
                        'user' => $user,
                        'type' => 'profileImage',
                        'relationType' => 'single'
                    ];

                    $this->storeDocuments($documentInfoArray);
                }
                if ($request->hasFile('cnic')) {
                    $documentInfoArray = [
                        'file' => $request->file('cnic'),
                        'user' => $user,
                        'type' => 'cnic',
                        'relationType' => 'single'
                    ];

                    $this->storeDocuments($documentInfoArray);
                }
                DB::commit();
                return redirect()->route('staff-members.index')->with('success', 'Staff member created successfully!');
            }
        }
        DB::rollback();
        return redirect()->back()->with('error', 'Staff member could not be created!');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $user = User::find($id);
        $profileImageObj =  $user->documents->where('type', 'profileImage')->first();
        $cnicObj = $user->documents->where('type', 'cnic')->first();
        
        return view('staff-members.edit', [
            'user' => $user,
            'profileImageObj' => $profileImageObj,
            'cnicObj' => $cnicObj
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(StaffMemberRequest $request, string $id)
    {
        $user = User::find($id);
        if ($user) {
            DB::beginTransaction();
            if ($user->update($request->user) && $user->member->update($request->member)) {
                if ($request->hasFile('profileImg')) {
                    $documentInfoArray = [
                        'file' => $request->file('profileImg'),
                        'user' => $user,
                        'type' => 'profileImage',
                        'relationType' => 'single'
                    ];

                    $this->storeDocuments($documentInfoArray);
                }
                if ($request->hasFile('cnic')) {
                    $documentInfoArray = [
                        'file' => $request->file('cnic'),
                        'user' => $user,
                        'type' => 'cnic',
                        'relationType' => 'single'
                    ];

                    $this->storeDocuments($documentInfoArray);
                }
                DB::commit();
                return redirect()->back()->with('success', 'Staff member updated successfully!');
            }
            else{
                DB::rollback();
                return redirect()->back()->with('error', 'Staff member could not be updated!');
            }
        }
        return redirect()->back()->with('error', 'Staff member not found!');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }

    public function searchStaffMember(Request $request){
        $user = new User;
        if ($request->name) {
            $user = $user->where('name', 'LIKE','%'.$request->name.'%');
        }
        if ($request->email) {
            $user = $user->where('email', 'LIKE','%'.$request->email.'%');
        }
        $users = $user->get();
        return view('staff-members.list', [
            'users' => $users
        ]);
    }
}
