<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Auth;
use App\Models\StaffMember;
use App\Models\User;

class StaffMemberRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $checkEmail = null;
        if ($this->isMethod('put')) {
            $checkEmail = User::find($this->route('staff_member'))?->email;
        }
        
        return [
            'user.name' => 'required',
            'user.email' => 'required|email',
            'user.email' => $this->isMethod('put')? 
                            ($this->user['email'] == $checkEmail? '' : 'unique:users,email') 
                                : 'unique:users,email',
            'member.contact_no' => 'numeric',
            'member.emergency_contact_no' => 'numeric',
            // 'member.cnic' => 'numeric|digits:13',
            'member.increment' => 'numeric'
        ];
    }

    public function messages(){
        return [
            'user.name.required' => 'Name is required',
            'user.email.required' => 'Email is required',
            'user.email.unique' => 'Email is already taken',
            'member.contact_no.numeric' => 'Contact number should be numric',
            'member.emergency_contact_no.numeric' => 'Emergency Contact number should be numric',
            'member.increment.numeric' => 'Increment should be a number'
        ];
    }
}
