<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Auth;

class Conversation extends Model
{
    protected $fillable = [
        'name', 'is_group'
    ];

    public function participants(){
        return $this->hasMany(Participant::class, 'conversation_id', 'id');
    }

    public function messages(){
        return $this->hasMany(Message::class, 'conversation_id', 'id');
    }

    // public function latestMessage(){
    //     return $this->hasOne(Message::class)->latestOfMany();
    // }

    public function chatUnreadMessages(){
        $messageIds = $this->messages->where('sender_id', '!=', Auth::id())->pluck('id')->toArray();
        return MessageRead::where([
                'user_id' => Auth::id(),
                'read_at' => null
            ])->whereIn('message_id', $messageIds)->count();
    }
}
