<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Lead extends Model
{
    protected $fillable = [
        'created_by_id', 'name', 'email', 'company', 'designation', 'country', 'date', 'attendee_type', 'team'
    ];

    public function user(){
        return $this->belongsTo(User::class, 'created_by_id', 'id');
    }

    public function comments(){
        return $this->hasMany(LeadComment::class, 'lead_id', 'id');
    }

    public function extras(){
        return $this->hasMany(LeadExtra::class, 'lead_id', 'id');
    }
}
