<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Message extends Model
{
    protected $fillable = [
        'conversation_id', 'sender_id', 'message', 'is_event'
    ];

    public function conversation(){
        return $this->belongsTo(Conversation::class);
    }
    public function sender(){
        return $this->belongsTo(User::class, 'sender_id', 'id');
    }

    public function messageReads(){
        return $this->hasMany(MessageRead::class, 'message_id', 'id');
    }
}
