<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use App\Notifications\CustomResetPassword;
use Auth;

class User extends Authenticatable
{
    /** @use HasFactory<\Database\Factories\UserFactory> */
    use HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'type'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var list<string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
        ];
    }

    public function member(){
        return $this->hasOne(StaffMember::class, 'user_id', 'id');
    }
    public function sendPasswordResetNotification($token){
        $this->notify(new CustomResetPassword($token));
    }

    public function documents(){
        return $this->morphToMany(Document::class, 'documentable');
    }

    public function totalUnreadMessages(){
        $messageIds = Message::where('sender_id', '!=', Auth::id())->pluck('id')->toArray();
        return MessageRead::where([
                'user_id' => Auth::id(),
                'read_at' => null
            ])->whereIn('message_id', $messageIds)->count();
    }
}