<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use App\Models\User;
use App\Models\Conversation;
use Auth;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        view()->composer('layouts.staff-member',function ($view){
            $users = User::where('type', 'staff_member')
                        ->where('id', '!=', Auth::id())
                        ->get();
            
            $view->with('users', $users);
        });

        view()->composer('layouts.staff-member',function ($view){
            $authUserId = Auth::id();
            $chatList = Conversation::whereHas('participants', function($q) use ($authUserId) {
                                        $q->where('user_id', $authUserId)->whereNull('left_at');
                                    })
                                    ->orderByDesc(
                                        Conversation::select('created_at')
                                            ->from('messages')
                                            ->whereColumn('messages.conversation_id', 'conversations.id')
                                            ->latest('created_at')
                                            ->limit(1)
                                    )
                                    ->get();
            
            $view->with('chatList', $chatList);
        });
    }
}
