<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('staff_members', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->id();
            $table->bigInteger('user_id')->nullable();
            $table->string('designation')->nullable();
            $table->string('bank_name')->nullable();
            $table->string('bank_account_name')->nullable();
            $table->string('bank_account_no')->nullable();
            $table->string('father_guradian_name')->nullable();
            $table->longText('address')->nullable();
            $table->string('contact_no')->nullable();
            $table->string('emergency_contact_no')->nullable();
            $table->string('qualification')->nullable();
            $table->date('date_of_joining')->nullable();
            $table->string('basic_salary')->nullable();
            $table->longText('allowances')->nullable();
            $table->string('increment')->nullable();
            // $table->dateTime('last_login');
            $table->boolean('is_updated')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('staff_members');
    }
};
