@extends('layouts.auth')

@section('content')
<!--begin::Form-->
<form method="POST" action="{{ route('password.update') }}" class="form w-100" novalidate="novalidate">
@csrf
    <input type="hidden" name="token" value="{{ $token }}">
    <!--begin::Heading-->
    <div class="text-center mb-10">
        <!--begin::Title-->
        <h1 class="text-dark fw-bolder mb-3">Setup New Password</h1>
        <!--end::Title-->
        <!--begin::Link-->
        <div class="text-gray-500 fw-semibold fs-6">Have you already reset the password ?
        <a href="{{ route('login') }}" class="link-primary fw-bold">Sign in</a></div>
        <!--end::Link-->
    </div>
    <!--begin::Heading-->
    <!--begin::Wrapper-->
    <div class="fv-row mb-8">
        <input type="email" placeholder="Email" name="email" value="{{ $email ?? old('email') }}" required autocomplete="email"
            class="form-control bg-transparent @error('email') is-invalid @enderror" />
        @error('email')
            <span class="invalid-feedback" role="alert">
                <strong>{{ $message }}</strong>
            </span>
        @enderror
    </div>
    <!--end::Input group=-->
    <!--begin::Input group-->
    <div class="fv-row mb-8" data-kt-password-meter="true">
        <div class="mb-1">
            <!--begin::Input wrapper-->
            <div class="position-relative mb-3">
                <input class="form-control bg-transparent" type="password" placeholder="Password" name="password" autocomplete="off" />
                <span class="btn btn-sm btn-icon position-absolute translate-middle top-50 end-0 me-n2" data-kt-password-meter-control="visibility">
                    <i class="bi bi-eye-slash fs-2"></i>
                    <i class="bi bi-eye fs-2 d-none"></i>
                </span>
            </div>
            <!--end::Input wrapper-->
            <!--begin::Meter-->
            <div class="d-flex align-items-center mb-3" data-kt-password-meter-control="highlight">
                <div class="flex-grow-1 bg-secondary bg-active-success rounded h-5px me-2"></div>
                <div class="flex-grow-1 bg-secondary bg-active-success rounded h-5px me-2"></div>
                <div class="flex-grow-1 bg-secondary bg-active-success rounded h-5px me-2"></div>
                <div class="flex-grow-1 bg-secondary bg-active-success rounded h-5px"></div>
            </div>
            <!--end::Meter-->
        </div>
        <!--end::Wrapper-->
        <!--begin::Hint-->
        <div class="text-muted">Use 8 or more characters with a mix of letters, numbers &amp; symbols.</div>
        <!--end::Hint-->
    </div>
    <!--end::Input group=-->
    <!--end::Input group=-->
    <div class="fv-row mb-8">
        <!--begin::Repeat Password-->
        <input type="password" placeholder="Repeat Password" name="password_confirmation" autocomplete="off"
            required autocomplete="new-password" class="form-control bg-transparent @error('password') is-invalid @enderror" />
        @error('password')
            <span class="invalid-feedback" role="alert">
                <strong>{{ $message }}</strong>
            </span>
        @enderror
        <!--end::Repeat Password-->
    </div>
    <!--end::Input group=-->
    <!--begin::Action-->
    <div class="d-grid mb-10">
        <button type="submit" id="kt_new_password_submit" class="btn btn-primary">
            <!--begin::Indicator label-->
            <span class="indicator-label">Submit</span>
            <!--end::Indicator label-->
            <!--begin::Indicator progress-->
            <span class="indicator-progress">Please wait...
            <span class="spinner-border spinner-border-sm align-middle ms-2"></span></span>
            <!--end::Indicator progress-->
        </button>
    </div>
    <!--end::Action-->
</form>
<!--end::Form-->
@endsection
