@extends('layouts.staff-member')

@section('content')
    <style>
        .form-container {
            margin: 30px auto;
        }
        .form-header {
            border-bottom: 2px solid #1e1e2d;
            padding-bottom: 10px;
        }
        .profile-img {
            width: 120px;
            height: 120px;
            object-fit: cover;
            border: 2px dashed #dee2e6;
            border-radius: 5px;
        }
        .upload-label {
            cursor: pointer;
        }
    </style>
    <div class="container py-4">
        <div class="form-container bg-white rounded p-4">
            <a href="{{ route('leads.index') }}" class="btn btn-primary" style="float: right">Back</a>
            <br>
            <h2 class="form-header text-center mb-4">Lead Form</h2>
            @if (session('success'))
                <div class="alert alert-success" role="alert">
                    {{ session('success') }}
                </div>
            @elseif(session('error'))
                <div class="alert alert-danger" role="alert">
                    {{ session('error') }}
                </div>
            @endif
            <form action="{{ route('leads.update', $lead->id) }}" method="post">
            @csrf
            @method('PUT')
                <input type="hidden" name="type" value="updateLead">
                <!-- Name and CNIC -->
                <div class="row mt-5 mb-3">
                    <div class="col-md-4">
                        <label class="form-label required">Name</label>
                        <input type="text" class="form-control @error('lead.name') is-invalid @enderror" name="lead[name]"
                            value="{{ $lead->name }}" required>
                        @error('lead.name')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                    <div class="col-md-4">
                        <label class="form-label required">Email</label>
                        <input type="email" class="form-control @error('lead.email') is-invalid @enderror" name="lead[email]" 
                            value="{{ $lead->email }}"
                            required>
                        @error('lead.email')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                    <div class="col-md-4">
                        <label class="form-label required">Designation</label>
                        <input type="text" class="form-control @error('lead.designation') is-invalid @enderror" 
                            name="lead[designation]" value="{{ $lead->designation }}" required>
                        @error('lead.designation')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                </div>

                <div class="row mt-5 mb-3">
                    <div class="col-md-4">
                        <label class="form-label required">Company</label>
                        <input type="text" class="form-control @error('lead.company') is-invalid @enderror" name="lead[company]"
                            value="{{ $lead->company }}" required>
                        @error('lead.company')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                    <div class="col-md-4">
                        <label class="form-label required">Country</label>
                        <input type="text" class="form-control @error('lead.country') is-invalid @enderror" name="lead[country]" value="{{ $lead->country }}"
                            required>
                        @error('lead.country')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                    <div class="col-md-4">
                        <label class="required form-label">Date</label>
                        <input type="date" class="form-control @error('lead.date') is-invalid @enderror" 
                            name="lead[date]" value="{{ $lead->date }}" required>
                    </div>
                </div>

                <div class="row mt-5 mb-3">
                    <div class="col-md-4">
                        <label class="form-label required">Attendee Type</label>
                        <input type="text" class="form-control @error('lead.attendee_type') is-invalid @enderror" name="lead[attendee_type]"
                            value="{{ $lead->attendee_type }}" required>
                        @error('lead.attendee_type')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                    <div class="col-md-4">
                        <label class="form-label required">Team</label>
                        <input type="text" class="form-control @error('lead.team') is-invalid @enderror" name="lead[team]" 
                            value="{{ $lead->team }}" required>
                        @error('lead.team')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                </div>

                <div class="repeater">
                    <div data-repeater-list="groupb">
                        @foreach($lead->extras as $extra)
                        <div data-repeater-item class="row">
                            <div class="mb-3 col-lg-5">
                                <div class="form-group">
                                    <label class="form-label">Extras</label>
                                    <select name="extras_type" class="form-select @error('extras') is-invalid @enderror">
                                        <option value="">---</option>
                                        <option {{ $extra->type == 'keynote_panel_topic'? 'selected' : '' }} value="keynote_panel_topic">Keynote/Panel Topic</option>
                                        <option {{ $extra->type == 'indications'? 'selected' : '' }} value="indications">Indications</option>
                                        <option {{ $extra->type == 'phase_of_pipeline'? 'selected' : '' }} value="phase_of_pipeline">Phase of Pipeline</option>
                                        <option {{ $extra->type == 'welcome_email'? 'selected' : '' }} value="welcome_email">Welcome Email</option>
                                        <option {{ $extra->type == 'info_status'? 'selected' : '' }} value="info_status">Info Status</option>
                                        <option {{ $extra->type == 'booklet_info_status'? 'selected' : '' }} value="booklet_info_status">Booklet Info Status</option>
                                        <option {{ $extra->type == 'booklet_follow_up'? 'selected' : '' }} value="booklet_follow_up">Booklet Follow Up</option>
                                        <option {{ $extra->type == 'card_status'? 'selected' : '' }} value="card_status">Card Status</option>
                                        <option {{ $extra->type == 'post_status'? 'selected' : '' }} value="post_status">Post Status</option>
                                        <option {{ $extra->type == 'venue_email'? 'selected' : '' }} value="venue_email">Venue Email</option>
                                    </select>
                                    @error('extras')
                                        <br>
                                        <div class="alert alert-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="mb-3 col-lg-6">
                                <label for="example-time-input" class="form-label">Enter text</label>
                                <input type="text" name="extras_text" class="form-control @error('extras_text') is-invalid @enderror"
                                    value="{{ $extra->value }}">
                                @error('extras_text')
                                    <br>
                                    <div class="alert alert-danger">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-lg-1 align-self-center d-grid" style="margin-top: 12px;">
                                <input data-repeater-delete type="button" class="btn btn-danger btn-block" value="Delete" />
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
                <div class="repeater mt-3">
                    <div data-repeater-list="groupa">
                        <div data-repeater-item class="row">
                            <div class="mb-3 col-lg-5">
                                <div class="form-group">
                                    <label class="form-label">Extras</label>
                                    <select name="extras_type" class="form-select @error('extras') is-invalid @enderror">
                                        <option value="">---</option>
                                        <option value="keynote_panel_topic">Keynote/Panel Topic</option>
                                        <option value="indications">Indications</option>
                                        <option value="phase_of_pipeline">Phase of Pipeline</option>
                                        <option value="welcome_email">Welcome Email</option>
                                        <option value="info_status">Info Status</option>
                                        <option value="booklet_info_status">Booklet Info Status</option>
                                        <option value="booklet_follow_up">Booklet Follow Up</option>
                                        <option value="card_status">Card Status</option>
                                        <option value="post_status">Post Status</option>
                                        <option value="venue_email">Venue Email</option>
                                    </select>
                                    @error('extras')
                                        <br>
                                        <div class="alert alert-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="mb-3 col-lg-6">
                                <label for="example-time-input" class="form-label">Enter text</label>
                                <input type="text" name="extras_text" class="form-control @error('text') is-invalid @enderror">
                                @error('text')
                                    <br>
                                    <div class="alert alert-danger">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-lg-1 align-self-center d-grid" style="margin-top: 18px;">
                                <input data-repeater-delete type="button" class="btn btn-danger btn-block" value="Delete" />
                            </div>
                        </div>
                    </div>
                    <input data-repeater-create type="button" class="btn btn-success mt-3 mt-lg-0" value="+ Add Slot" />
                </div>
                
                <!-- Save Button -->
                <div class="text-center">
                    <button type="submit" class="btn btn-primary px-4 w-50">SAVE</button>
                </div>
            </form>
        </div>
    </div>
    
    
    <!-- <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script> -->
@endsection