@extends('layouts.admin')

@section('content')
    <div class="container py-4">
        <div class="form-container bg-white rounded p-4">
            <h2 class="page-heading d-flex text-dark fw-bold fs-3 flex-column justify-content-center my-0 mb-4">Edit Profile</h2>
            <hr>
            @if (session('success'))
                <div class="alert alert-success" role="alert">
                    {{ session('success') }}
                </div>
            @elseif(session('error'))
                <div class="alert alert-danger" role="alert">
                    {{ session('error') }}
                </div>
            @endif

            <form action="{{ route('profile.update', $user->id) }}" method="post" enctype="multipart/form-data">
            @csrf
            @method('PUT')
                <input type="hidden" name="type" value="adminProfileUpdate">
                <!-- Profile Image Upload -->
                <div class="row mb-4">
                    <div class="col-lg-3"></div>
                    <div class="col-md-6 text-center">
                        <div class="mb-3">
                            <div class="mt-3 mb-3">
                                <label for="profileImage" class="upload-label btn btn-sm btn-outline-primary">
                                    Upload Image
                                </label>
                                <input type="file" id="profileImage" class="form-control" name="profileImg" accept="image/*">
                            </div>
                            <img id="preview" src="{{ asset('storage/'. $profileImageObj?->file_path) }}" 
                                alt="{{ $profileImageObj?->file_name }}" style="display:block; max-width: 200px;" />
                        </div>
                    </div>
                    <div class="col-lg-3"></div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-6">
                        <label class="form-label required">Name</label>
                        <input type="text" class="form-control @error('name') is-invalid @enderror" name="name" value="{{ $user->name }}"
                            required>
                        @error('name')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                    <div class="col-md-6">
                        <label class="form-label required">Email</label>
                        <input type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ $user->email }}"
                            required>
                        @error('email')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                </div>
                <br>
                <div class="text-center">
                    <button type="submit" class="btn btn-primary px-4 w-50">Update</button>
                </div>
            </form>
        </div>
    </div>

    <div class="container py-4">
        <div class="form-container bg-white rounded p-4">
            <h2 class="page-heading d-flex text-dark fw-bold fs-3 flex-column justify-content-center my-0 mb-4">Change Password</h2>
            <hr>
            <form action="{{ route('profile.update', $user->id) }}" method="post">
            @csrf
            @method('PUT')
                <input type="hidden" name="type" value="updatePassword">
                <div class="mb-6 form-password-toggle">
                    <label class="form-label" for="password">Current Password</label>
                    <div class="input-group input-group-merge">
                        <input type="password" id="password" class="form-control @error('current_password') is-invalid @enderror" placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;" aria-describedby="password" 
                            name="current_password" required autocomplete="new-password"/>
                        <span class="input-group-text cursor-pointer"><i class="ti ti-eye-off"></i></span>
                        @error('current_password')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                </div>

                <div class="mb-6 form-password-toggle">
                    <label class="form-label" for="password">New Password</label>
                    <div class="input-group input-group-merge">
                        <input type="password" id="password" class="form-control @error('password') is-invalid @enderror" placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;" aria-describedby="password" 
                            name="password" required autocomplete="new-password"/>
                        <span class="input-group-text cursor-pointer"><i class="ti ti-eye-off"></i></span>
                        @error('password')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                </div>

                <div class="mb-6 form-password-toggle">
                    <label class="form-label" for="password">Confirm Password</label>
                    <div class="input-group input-group-merge">

                    <input type="password" id="password-confirm" class="form-control @error('password_confirmation') is-invalid @enderror"
                        placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;" aria-describedby="password_confirmation" 
                        name="password_confirmation" required autocomplete="new-password"/>
                    <span class="input-group-text cursor-pointer"><i class="ti ti-eye-off"></i></span>
                    @error('password_confirmation')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                    @enderror
                </div>
                <br>
                <div class="text-center">
                    <button type="submit" class="btn btn-primary px-4 w-50">Update</button>
                </div>

            </form>
        </div>
    </div>


    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $('#profileImage').on('change', function (event) {
            const input = event.target;

            if (input.files && input.files[0]) {
                const reader = new FileReader();

                reader.onload = function (e) {
                    $('#preview').attr('src', e.target.result).show();
                };

                reader.readAsDataURL(input.files[0]);
            } else {
                // If no file selected, hide the image
                $('#preview').attr('src', '#').hide();
            }
        });
    </script>
@endsection