@extends('layouts.admin')

@section('content')
    <style>
        .form-container {
            margin: 30px auto;
        }
        .form-header {
            border-bottom: 2px solid #1e1e2d;
            padding-bottom: 10px;
        }
        .profile-img {
            width: 120px;
            height: 120px;
            object-fit: cover;
            border: 2px dashed #dee2e6;
            border-radius: 5px;
        }
        .upload-label {
            cursor: pointer;
        }
    </style>
    <div class="container py-4">
        <div class="form-container bg-white rounded p-4">
            <a href="{{ route('staff-members.index') }}" class="btn btn-primary" style="float: right">Back</a>
            <br>
            <h2 class="form-header text-center mb-4">STAFF REGISTRATION FORM</h2>
            @if (session('success'))
                <div class="alert alert-success" role="alert">
                    {{ session('success') }}
                </div>
            @elseif(session('error'))
                <div class="alert alert-danger" role="alert">
                    {{ session('error') }}
                </div>
            @endif
            <form action="{{ route('staff-members.store') }}" method="post" enctype="multipart/form-data">
            @csrf
                <!-- Profile Image Upload -->
                <div class="row mb-4">
                    <div class="col-md-6 text-center">
                        <div class="mb-3">
                            <div class="mt-3 mb-3">
                                <label for="profileImage" class="upload-label btn btn-sm btn-outline-primary">
                                    Upload Image
                                </label>
                                <input type="file" id="profileImage" class="form-control" name="profileImg" accept="image/*">
                            </div>
                            <img id="preview" src="#" alt="Image Preview" style="display:none; max-width: 200px;" />
                        </div>
                    </div>
                    <div class="col-md-6 text-center">
                        <div class="mb-3">
                            <img id="preview" src="#" alt="Cnic Preview" style="display:none; max-width: 200px;" />
                            <div class="mt-3 mb-3">
                                <label for="cnicImage" class="upload-label btn btn-sm btn-outline-primary">
                                    CNIC UPLOAD
                                </label>
                                <input type="file" id="cnicImage" class="form-control" name="cnic" accept="image/*">
                            </div>
                            <img id="cnicPreview" src="#" alt="Cnic Preview" style="display:none; max-width: 200px;" />
                        </div>
                    </div>
                </div>
                
                <!-- Name and CNIC -->
                <div class="row mb-3">
                    <div class="col-md-4">
                        <label class="form-label required">Name</label>
                        <input type="text" class="form-control @error('user.name') is-invalid @enderror" name="user[name]"
                            value="{{ old('user.name') }}" required>
                        @error('user.name')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                    <div class="col-md-4">
                        <label class="form-label required">Email</label>
                        <input type="email" class="form-control @error('user.email') is-invalid @enderror" name="user[email]" value="{{ old('user.email') }}"
                            required>
                        @error('user.email')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Designation</label>
                        <input type="text" class="form-control @error('member.designation') is-invalid @enderror" 
                            name="member[designation]" value="{{ old('member.designation') }}">
                        @error('member.designation')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                </div>
                
                <!-- Bank Details -->
                <div class="row mb-3 pt-3">
                    <div class="col-md-4">
                        <label class="form-label">BANK ACCOUNT NAME</label>
                        <input type="text" class="form-control @error('member.bank_account_name') is-invalid @enderror" 
                            name="member[bank_account_name]" value="{{ old('member.bank_account_name') }}">
                        @error('member.bank_account_name')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">BANK NAME</label>
                        <input type="text" class="form-control @error('member.bank_name') is-invalid @enderror" name="member[bank_name]"
                            value="{{ old('member.bank_name') }}">
                        @error('member.bank_name')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">BANK ACCOUNT NO</label>
                        <input type="text" class="form-control @error('member.bank_account_no') is-invalid @enderror"
                            name="member[bank_account_no]" value="{{ old('member.bank_account_no') }}">
                        @error('member.bank_account_no')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                </div>
                
                <!-- Personal Details -->
                <div class="row mb-3 pt-3">
                    <div class="col-md-6">
                        <label class="form-label">FATHER/GUARDIAN NAME</label>
                        <input type="text" class="form-control @error('member.father_guradian_name') is-invalid @enderror"
                            name="member[father_guradian_name]" value="{{ old('member.father_guradian_name') }}">
                        @error('member.father_guradian_name')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">HOME ADDRESS</label>
                        <input type="text" class="form-control @error('member.address') is-invalid @enderror" name="member[address]"
                            value="{{ old('member.address') }}">
                        @error('member.address')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                </div>
                
                <!-- Contact Details -->
                <div class="row mb-3 pt-3">
                    <div class="col-md-4">
                        <label class="form-label">CONTACT NO</label>
                        <input type="text" class="form-control @error('member.contact_no') is-invalid @enderror" name="member[contact_no]"
                            value="{{ old('member.contact_no') }}">
                        @error('member.contact_no')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">EMERGENCY CONTACT NO</label>
                        <input type="text" class="form-control @error('member.emergency_contact_no') is-invalid @enderror" 
                            name="member[emergency_contact_no]" value="{{ old('member.emergency_contact_no') }}">
                        @error('member.emergency_contact_no')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">QUALIFICATION</label>
                        <input type="text" class="form-control @error('member.qualification') is-invalid @enderror"
                            name="member[qualification]" value="{{ old('member.qualification') }}">
                        @error('member.qualification')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                </div>
                
                <!-- Employment Details -->
                <div class="row mb-4 pt-3">
                    <div class="col-md-4">
                        <label class="form-label">DATE OF JOINING</label>
                        <input type="date" class="form-control @error('member.date_of_joining') is-invalid @enderror" 
                            name="member[date_of_joining]" value="{{ old('member.date_of_joining') }}">
                        @error('member.date_of_joining')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">BASIC SALARY <span style="font-size: 12px">(PER MONTH)</span></label>
                        <input type="text" class="form-control @error('member.basic_salary') is-invalid @enderror" placeholder="XX,XXX/- "
                            name="member[basic_salary]" value="{{ old('member.basic_salary') }}">
                        @error('member.basic_salary')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">INCREMENT <span style="font-size: 12px">(% PER YEAR/BASIC)</span></label>
                        <input type="text" class="form-control @error('member.increment') is-invalid @enderror" placeholder="10"
                            name="member[increment]" value="{{ old('member.increment') }}">
                        @error('member.increment')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                </div>
                
                <!-- Allowances -->
                <div class="row mb-4 pt-3">
                    <div class="col-md-12">
                        <label class="form-label">ALLOWANCES</label>
                        <textarea class="form-control @error('member.allowances') is-invalid @enderror" rows="3" name="member[allowances]"
                            >{{ old('member.allowances') }}</textarea>
                        @error('member.allowances')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                </div>
                
                <!-- Save Button -->
                <div class="text-center">
                    <button type="submit" class="btn btn-primary px-4 w-50">SAVE</button>
                </div>
            </form>
        </div>
    </div>
    
    
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $('#profileImage').on('change', function (event) {
            const input = event.target;

            if (input.files && input.files[0]) {
                const reader = new FileReader();

                reader.onload = function (e) {
                    $('#preview').attr('src', e.target.result).show();
                };

                reader.readAsDataURL(input.files[0]);
            } else {
                // If no file selected, hide the image
                $('#preview').attr('src', '#').hide();
            }
        });

        $('#cnicImage').on('change', function (event) {
            const input = event.target;

            if (input.files && input.files[0]) {
                const reader = new FileReader();

                reader.onload = function (e) {
                    $('#cnicPreview').attr('src', e.target.result).show();
                };

                reader.readAsDataURL(input.files[0]);
            } else {
                // If no file selected, hide the image
                $('#cnicPreview').attr('src', '#').hide();
            }
        });
    </script>
@endsection