<?php

use Illuminate\Support\Facades\Broadcast;
use App\Models\Conversation;

Broadcast::channel('chat.{conversation_id}', function ($user, $conversation_id) {
    $conversation = Conversation::find($conversation_id);

    if(!$conversation) return false;
    
    return $conversation && $conversation->participants->contains('user_id', $user->id)
        ? ['id' => $user->id] : false;

    // return (int) $user->id === (int) $userId;
});
