<?php

use Illuminate\Support\Facades\Route;
use App\Http\Middleware\AdminPermission;

Route::get('/', function () {
    return redirect('/login');
});

Auth::routes();

Route::group(['middleware' => ['auth']], function (){
    Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');        
    Route::resource('leads', App\Http\Controllers\LeadController::class);
    Route::resource('profile', App\Http\Controllers\ProfileController::class);
    Route::resource('chats', App\Http\Controllers\ChatController::class);
    Route::post('/send-message', [App\Http\Controllers\ChatController::class, 'sendMessage'])->name('sendMessage');
    Route::post('/start-conversation', [App\Http\Controllers\ChatController::class, 'startConversation'])->name('startConversation');
    Route::get('/start-chat', [App\Http\Controllers\ChatController::class, 'searchChat'])->name('searchChat');
    
    Route::middleware('admin')->group(function () {
        Route::resource('staff-members', App\Http\Controllers\StaffMemberController::class);
        Route::get('/search-staff-members', [App\Http\Controllers\StaffMemberController::class, 'searchStaffMember'])->name('searchStaffMember');
    });
});