<?php $__env->startSection('content'); ?>

<div class="app-main flex-column flex-row-fluid" id="kt_app_main">
    <!--begin::Content wrapper-->
    <div class="d-flex flex-column flex-column-fluid">
        <!--begin::Toolbar-->
        <div id="kt_app_toolbar" class="app-toolbar py-3 py-lg-6">
            <!--begin::Toolbar container-->
            <div id="kt_app_toolbar_container" class="app-container container-xxl d-flex flex-stack">
                <h1 class="page-heading d-flex text-dark fw-bold fs-3 flex-column justify-content-center my-0">Chat Box</h1>
                <a href="<?php echo e(route('chats.index')); ?>" class="float-right">
                    <button class="btn btn-primary">Back</button>
                </a>
            </div>
            <!--end::Toolbar container-->
        </div>
        <!--end::Toolbar-->
        <!--begin::Content-->
        <div id="kt_app_content" class="app-content flex-column-fluid">
            <!--begin::Content container-->
            <div id="kt_app_content_container" class="app-container container-xxl">
                <!--begin::Layout-->
                <?php if(session('success')): ?>
                    <div class="alert alert-success" role="alert">
                        <?php echo e(session('success')); ?>

                    </div>
                <?php elseif(session('error')): ?>
                    <div class="alert alert-danger" role="alert">
                        <?php echo e(session('error')); ?>

                    </div>
                <?php endif; ?>
                <div class="d-flex flex-column flex-lg-row">
                    <!--begin::Content-->
                    <div class="flex-lg-row-fluid ms-lg-7 ms-xl-10">
                        <!--begin::Messenger-->
                        <div class="card" id="kt_chat_messenger">
                            <!--begin::Card header-->
                            <div class="card-header" id="kt_chat_messenger_header">
                                <!--begin::Title-->
                                <div class="card-title">
                                    <!--begin::User-->
                                    <div class="d-flex justify-content-center flex-column me-3">
                                        <?php if($conversation->is_group): ?>
                                            <span data-bs-toggle="modal" data-bs-target="#group-name" class="fs-4 fw-bold text-gray-900 text-hover-primary me-1 mb-2 lh-1" type="submit"
                                                style="background:none; border:none; padding:0; color:#009ef7; cursor:pointer;">
                                                <?php echo e($conversation->name); ?>

                                            </span>
                                        <?php else: ?>
                                            <span class="fs-4 fw-bold text-gray-900 text-hover-primary me-1 mb-2 lh-1" type="submit"
                                                style="background:none; border:none; padding:0; color:#009ef7; cursor:pointer;">
                                                <?php echo e($receiver->name); ?>

                                            </span>
                                        <?php endif; ?>
                                        <!--begin::Info-->
                                        <div class="mb-0 lh-1">
                                            <!-- <span class="badge badge-success badge-circle w-10px h-10px me-1"></span>
                                            <span class="fs-7 fw-semibold text-muted">Active</span> -->
                                        </div>
                                        <!--end::Info-->
                                    </div>
                                    <!--end::User-->
                                </div>
                                <!--end::Title-->
                                <!--begin::Card toolbar-->
                                <div class="card-toolbar">
                                    <!--begin::Menu-->
                                    <div class="me-n3">
                                        <?php if($conversation->is_group): ?>
                                            <button class="btn btn-sm btn-icon btn-active-light-primary" data-kt-menu-trigger="click" data-kt-menu-placement="bottom-end">
                                                <i class="bi bi-three-dots fs-2"></i>
                                            </button>
                                        <?php endif; ?>
                                        <!--begin::Menu 3-->
                                        <div class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-gray-800 menu-state-bg-light-primary fw-semibold w-200px py-3" data-kt-menu="true">
                                            <!--begin::Heading-->
                                            <div class="menu-item px-3">
                                                <div class="menu-content text-muted pb-2 px-3 fs-7 text-uppercase">Others</div>
                                            </div>
                                            <!--end::Heading-->
                                            <!--begin::Menu item-->
                                            <div class="menu-item px-3">
                                                <a class="menu-link px-3" data-bs-toggle="modal" data-bs-target="#group-members">Group members</a>
                                                <a class="menu-link px-3" data-bs-toggle="modal" data-bs-target="#group-name">Change group name</a>
                                            </div>
                                            <!--end::Menu item-->
                                        </div>
                                        <!--end::Menu 3-->
                                    </div>
                                    <!--end::Menu-->
                                </div>
                                <!--end::Card toolbar-->
                            </div>
                            <!--end::Card header-->
                            <!--begin::Card body-->
                            <div class="card-body" id="kt_chat_messenger_body">
                                <!--begin::Messages-->
                                <div class="scroll-y me-n5 pe-5 h-300px h-lg-auto" data-kt-element="messages" data-kt-scroll="true" 
                                    data-kt-scroll-activate="{default: false, lg: true}" data-kt-scroll-max-height="auto"
                                    data-kt-scroll-dependencies="#kt_header, #kt_toolbar, #kt_footer, #kt_chat_messenger_header, #kt_chat_messenger_footer" 
                                    data-kt-scroll-wrappers="#kt_content, #kt_chat_messenger_body" data-kt-scroll-offset="5px" id="scroll-chat-box">
                                    
                                    <?php $__currentLoopData = $conversation->messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($message->is_event): ?>
                                            <div class="text-center text-primary my-3">
                                                <span class="fw-bold"><?php echo e($message->sender->name); ?></span> <?php echo e($message->message); ?>

                                            </div>
                                        <?php elseif($message->sender_id != Auth::id()): ?>
                                            <div class="d-flex justify-content-start mb-10">
                                            <!--begin::Wrapper-->
                                                <div class="d-flex flex-column align-items-start">
                                                    <!--begin::User-->
                                                    <div class="d-flex align-items-center mb-2">
                                                        <!--begin::Avatar-->
                                                        <div class="symbol symbol-35px symbol-circle"></div>
                                                        <!--end::Avatar-->
                                                        <!--begin::Details-->
                                                        <div class="ms-3">
                                                            <span class="fs-5 fw-bold text-gray-900 text-hover-primary me-1"><?php echo e($message->sender->name); ?></span>
                                                            <span class="text-muted fs-7 mb-1"><?php echo e($message->created_at->format('H:i d-M-Y')); ?></span>
                                                        </div>
                                                        <!--end::Details-->
                                                        
                                                    </div>
                                                    <!--end::User-->
                                                    <!--begin::Text-->
                                                    <div class="p-5 rounded bg-light-info text-dark fw-semibold mw-lg-400px text-start" data-kt-element="message-text">
                                                        <?php echo e($message->message); ?>

                                                    </div>
                                                    <!--end::Text-->
                                                </div>
                                                <!--end::Wrapper-->
                                            </div>
                                        <?php elseif($message->sender_id == Auth::id()): ?>
                                            <div class="d-flex justify-content-end mb-10">
                                                <!--begin::Wrapper-->
                                                <div class="d-flex flex-column align-items-end">
                                                    <!--begin::User-->
                                                    <div class="d-flex align-items-center mb-2">
                                                        <!--begin::Details-->
                                                        <div class="me-3">
                                                            <!-- <a href="#" class="fs-5 fw-bold text-gray-900 text-hover-primary ms-1">You</a> -->
                                                        </div>
                                                        <!--end::Details-->
                                                        <!--begin::Avatar-->
                                                        <div class="symbol symbol-35px symbol-circle"></div>
                                                        <!--end::Avatar-->
                                                        <div class="ms-3">
                                                            <span class="fs-5 fw-bold text-gray-900 text-hover-primary me-1"><?php echo e($message->sender->name); ?></span>
                                                            <span class="text-muted fs-7 mb-1"><?php echo e($message->created_at->format('H:i d-M-Y')); ?></span>
                                                        </div>
                                                    </div>
                                                    <!--end::User-->
                                                    <!--begin::Text-->
                                                    <div class="p-5 rounded bg-light-primary text-dark fw-semibold mw-lg-400px text-end" data-kt-element="message-text">
                                                        <?php echo e($message->message); ?>

                                                    </div>
                                                    <!--end::Text-->
                                                </div>
                                                <!--end::Wrapper-->
                                            </div>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    <div id="chat-messages"></div>
                                </div>
                                <!--end::Messages-->
                            </div>
                            <!--end::Card body-->
                            <!--begin::Card footer-->
                            <div class="card-footer pt-4" id="kt_chat_messenger_footer">
                                <form id="chat-form">
                                    <?php echo csrf_field(); ?>
                                    <!--begin::Input-->
                                    <input type="hidden" name="conversation_id" value="<?php echo e($conversation->id); ?>" id="conversation_id">
                                    <input type="hidden" name="receiver_id" value="<?php echo e($conversation->id); ?>" id="receiver_id">
                                    <textarea class="form-control form-control-flush mb-3" rows="1" id="message" 
                                        data-kt-element="input" placeholder="Type a message" name="message" required></textarea>
                                    <!--end::Input-->
                                    <!--begin:Toolbar-->
                                    <div class="d-flex flex-stack">
                                        <!--begin::Send-->
                                        <button class="btn btn-success" type="submit" data-kt-element="send">Send</button>
                                        <!--end::Send-->
                                    </div>
                                    <!--end::Toolbar-->
                                </form>
                            </div>
                            <!--end::Card footer-->
                        </div>
                        <!--end::Messenger-->
                    </div>
                    <!--end::Content-->
                </div>
                <!--end::Layout-->
            </div>
            <!--end::Content container-->
        </div>
        <!--end::Content-->
    </div>
    <!--end::Content wrapper-->
</div>


<!-- View/Add Group Members -->
<div class="modal fade" id="group-members" aria-labelledby="group-membersLabel" tabindex="-1" style="display: none;" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="group-membersLabel">Group Members</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="<?php echo e(route('startConversation')); ?>" method="post">
                <?php echo csrf_field(); ?>
                    <input type="hidden" name="type" value="add_member">
                    <input type="hidden" name="conversation_id" value="<?php echo e($conversation->id); ?>">
                    <label class="form-label">Add new member</label>
                    <div class="row">
                        <div class="col-lg-8">
                            <select class="form-select add-member form-select-solid" data-control="select2" data-hide-search="true" 
                                    multiple data-placeholder="Add member to the conversation" name="members[]" required>
                                <option value="">Select member</option>
                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($user->id); ?>"><?php echo e($user->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <br>
                        </div>
                        <div class="col-lg-4">
                            <button type="submit" class="btn btn-success mx-3">+ Add</button>
                        </div>
                    </div>
                </form>
                <br>
                <?php $__currentLoopData = $conversation->participants->whereNull('left_at'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $participant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="d-flex flex-stack" data-id="<?php echo e($participant->user_id); ?>">
                        <span class="d-flex align-items-center fs-5 fw-bold text-dark text-hover-primary">
                            <?php echo e($participant->user->name); ?>

                            <?php echo e($participant->user_id == Auth::id()? '(You)' : ''); ?>

                        </span>
                        <?php if($participant->user_id == Auth::id()): ?>
                            <a data-bs-toggle="modal" data-bs-target="#remove-member" data-id="<?php echo e($participant->user_id); ?>" id="remove-participant"
                                class="btn btn-icon btn-bg-light btn-active-color-primary btn-sm" title="Leave Group" style="float: right">
                                <span class="svg-icon svg-icon-3">
                                    <i class="fa-solid fa-person-walking-arrow-right fs-17"></i>
                                </span>
                            </a>
                        <?php endif; ?>
                    </div>
                    <hr data-id="<?php echo e($participant->user_id); ?>">
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <div id="participant-list"></div>
                
            </div>
            <div class="modal-footer">
                <button class="btn btn-primary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<!-- Remove Group Member Confirmation Message -->
<div class="modal fade" id="remove-member" aria-labelledby="remove-memberLabel" tabindex="-1" style="display: none;" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="remove-memberLabel">Confirm</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                Are you sure, you want to leave the group?
                <form action="<?php echo e(route('chats.destroy', $conversation->id)); ?>" method="post">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                    <input type="hidden" name="type" value="leave_group">
                    <!-- <input type="hidden" name="user_id" value=""> -->
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-danger">Exit</button>
                </form>
                <button class="btn btn-primary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<!-- Start New Chat -->
<div class="modal fade" id="group-name" aria-labelledby="group-nameLabel" tabindex="-1" style="display: none;" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="group-nameLabel">Edit Chat Name</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="<?php echo e(route('chats.update', $conversation->id)); ?>" method="post">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                    <input type="hidden" name="type" value="update_group_name">
                    <input type="text" class="form-control" name="group_name" value="<?php echo e($conversation->name); ?>">
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-success">Change</button>
                </form>
                <button class="btn btn-primary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.5.1.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/axios/1.1.2/axios.min.js"></script>
<script src="https://js.pusher.com/7.2/pusher.min.js"></script>


<script>
    window.onload = function () {
        const container = document.getElementById('scroll-chat-box');
        container.scrollTop = container.scrollHeight;
    };
     $(document).ready(function () {
        let conversation_id = <?php echo e($conversation->id); ?>;
        let userName = '<?php echo e(auth()->user()->name); ?>';
        $('#chat-form').submit(function(e) {
            e.preventDefault();
            let msg = $('#message').val();
            // let conversation_id = $('#conversation_id').val();
            
            $('#message').val('');

            $.ajax({
                type: "POST",
                url: "<?php echo e(route('sendMessage')); ?>",
                headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
                data: { 
                    message: msg,
                    conversation_id: conversation_id
                },
                success: function(response) {
                    if (response.message) {
                        let formatted = formatTimestamp(response.message.created_at);
                        html = `
                            <div class="d-flex justify-content-end mb-10">
                                <!--begin::Wrapper-->
                                <div class="d-flex flex-column align-items-end">
                                    <!--begin::User-->
                                    <div class="d-flex align-items-center mb-2">
                                        <!--begin::Details-->
                                        <div class="me-3">
                                            <span class="text-muted fs-7 mb-1"></span>
                                        </div>
                                        <!--end::Details-->
                                        <!--begin::Avatar-->
                                        <div class="symbol symbol-35px symbol-circle"></div>
                                        <!--end::Avatar-->
                                        <div class="ms-3">
                                            <span class="fs-5 fw-bold text-gray-900 text-hover-primary me-1">${userName}</span>
                                            <span class="text-muted fs-7 mb-1">${formatted}</span>
                                        </div>
                                    </div>
                                    <!--end::User-->
                                    <!--begin::Text-->
                                    <div class="p-5 rounded bg-light-primary text-dark fw-semibold mw-lg-400px text-end" 
                                        data-kt-element="message-text">${response.message.message}</div>
                                    <!--end::Text-->
                                </div>
                                <!--end::Wrapper-->
                            </div>
                        `;
                        $('#chat-messages').append(html);
                        const container = document.getElementById('scroll-chat-box');
                        container.scrollTop = container.scrollHeight;   
                    }
                    else{
                        toastr.error('Unable to send message');
                    }
                }
            });
        });

        userId = <?php echo e(auth()->user()->id); ?>;
        window.Echo.join(`chat.${conversation_id}`)
            .listen('MessageSent', function (e) {
                if (e.message.is_event && e.message.message == 'left the group') {
                    memberLeft(e)
                }
                else if (e.message.is_event && e.message.message == 'joined the group') {
                    memberJoined(e)
                }
                else{
                    appendMessage(e)
                }
                const container = document.getElementById('scroll-chat-box');
                container.scrollTop = container.scrollHeight;
            })
        
        function appendMessage(e){
            let formatted = formatTimestamp(e.message.created_at);
            html = `
                <div class="d-flex justify-content-start mb-10">
                    <!--begin::Wrapper-->
                    <div class="d-flex flex-column align-items-start">
                        <!--begin::User-->
                        <div class="d-flex align-items-center mb-2">
                            <!--begin::Avatar-->
                            <div class="symbol symbol-35px symbol-circle"></div>
                            <!--end::Avatar-->
                            <!--begin::Details-->
                            <div class="ms-3">
                                <span class="text-muted fs-7 mb-1"></span>
                            </div>
                            <!--end::Details-->
                            <div class="ms-3">
                                <span class="fs-5 fw-bold text-gray-900 text-hover-primary me-1">${e.message.sender.name}</span>
                                <span class="text-muted fs-7 mb-1">${formatted}</span>
                            </div>
                        </div>
                        <!--end::User-->
                        <!--begin::Text-->
                        <div class="p-5 rounded bg-light-info text-dark fw-semibold mw-lg-400px text-start" data-kt-element="message-text">
                            ${e.message.message}
                        </div>
                        <!--end::Text-->
                    </div>
            `;
            $('#chat-messages').append(html);
        }
        
        function memberJoined(e){
            let selectElement = document.querySelector('.add-member');
            optionToRemove = selectElement.querySelector('option[value="' + e.message.sender_id + '"]');
            
            if (optionToRemove) {
                optionToRemove.remove();
            }

            let container = document.querySelector('#participant-list');
            if (container) {
                let span = document.createElement('span');

                span.className = "d-flex align-items-center fs-5 fw-bold text-dark text-hover-primary";
                span.setAttribute('data-id', e.message.sender_id);
                span.textContent = e.message.sender.name;

                let hr = document.createElement('hr');
                hr.setAttribute('data-id', e.message.sender_id);

                container.appendChild(span);
                container.appendChild(hr);
            }

            let html = `
                <div class="text-center text-primary my-3">
                    <span class="fw-bold">${e.message.sender.name}</span> ${e.message.message}
                </div>
            `;
            $('#chat-messages').append(html);
        }

        function memberLeft(e){
            let selectElement = document.querySelector('.add-member');
            let newOption = new Option(e.message.sender.name, e.message.sender_id);
            selectElement.add(newOption);
            
            $(selectElement).trigger('change');

            let spanElement = document.querySelector(`div[data-id='${e.message.sender_id}']`);
            if (spanElement) spanElement.remove();
            
            let hrElement = document.querySelector(`hr[data-id='${e.message.sender_id}']`);
            if (hrElement) hrElement.remove();

            let html = `
                <div class="text-center text-primary my-3">
                    <span class="fw-bold">${e.message.sender.name}</span> ${e.message.message}
                </div>
            `;
            $('#chat-messages').append(html);
        }

        function formatTimestamp(isoString) {
            const date = new Date(isoString);

            const hours = String(date.getUTCHours()).padStart(2, '0');
            const minutes = String(date.getUTCMinutes()).padStart(2, '0');
            const day = String(date.getUTCDate()).padStart(2, '0');
            const monthNames = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", 
                                "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
            const month = monthNames[date.getUTCMonth()];
            const year = date.getUTCFullYear();

            return `${hours}:${minutes} ${day}-${month}-${year}`;
        }
     });

</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.staff-member', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ppsoppwg/public_html/resources/views/chats/chat-box.blade.php ENDPATH**/ ?>